#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/rr/header.h"
extern u8 _rr_segment_ESegmentRomStart[];
extern u8 _rr_segment_ESegmentRomEnd[];

const LevelScript level_rr_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _rr_segment_7SegmentRomStart, _rr_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _rrSegmentRomStart, _rrSegmentRomEnd),
LOAD_RAW(0x0E, _rr_segment_ESegmentRomStart, _rr_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _clouds_skybox_mio0SegmentRomStart, _clouds_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group11_mio0SegmentRomStart, _group11_mio0SegmentRomEnd),
LOAD_RAW(12, _group11_geoSegmentRomStart, _group11_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_03,           rr_geo_000660),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_04,           rr_geo_000678),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_05,           rr_geo_000690),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_06,           rr_geo_0006A8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_07,           rr_geo_0006C0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_08,           rr_geo_0006D8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_09,           rr_geo_0006F0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0A,           rr_geo_000708),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0B,           rr_geo_000720),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0C,           rr_geo_000738),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0D,           rr_geo_000758),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0E,           rr_geo_000770),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0F,           rr_geo_000788),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_10,           rr_geo_0007A0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_11,           rr_geo_0007B8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_12,           rr_geo_0007D0),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_13,           rr_geo_0007E8),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_14,           rr_geo_000800),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_15,           rr_geo_000818),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_16,           rr_geo_000830),
LOAD_MODEL_FROM_GEO(MODEL_RR_SLIDING_PLATFORM,         rr_geo_0008C0),
LOAD_MODEL_FROM_GEO(MODEL_RR_FLYING_CARPET,            rr_geo_000848),
LOAD_MODEL_FROM_GEO(MODEL_RR_OCTAGONAL_PLATFORM,       rr_geo_0008A8),
LOAD_MODEL_FROM_GEO(MODEL_RR_ROTATING_BRIDGE_PLATFORM, rr_geo_000878),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRIANGLE_PLATFORM,        rr_geo_0008D8),
LOAD_MODEL_FROM_GEO(MODEL_RR_CRUISER_WING,             rr_geo_000890),
LOAD_MODEL_FROM_GEO(MODEL_RR_SEESAW_PLATFORM,          rr_geo_000908),
LOAD_MODEL_FROM_GEO(MODEL_RR_L_SHAPED_PLATFORM,        rr_geo_000940),
LOAD_MODEL_FROM_GEO(MODEL_RR_SWINGING_PLATFORM,        rr_geo_000860),
LOAD_MODEL_FROM_GEO(MODEL_RR_DONUT_PLATFORM,           rr_geo_000920),
LOAD_MODEL_FROM_GEO(MODEL_RR_ELEVATOR_PLATFORM,        rr_geo_0008F0),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES,         rr_geo_000958),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME1,  rr_geo_000970),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME2,  rr_geo_000988),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME3,  rr_geo_0009A0),
LOAD_MODEL_FROM_GEO(MODEL_RR_TRICKY_TRIANGLES_FRAME4,  rr_geo_0009B8),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(88, 0x0500c778),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_12),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_rr_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_rr_1_[] = {
AREA(1, Geo_rr_1_0x189fc40),
TERRAIN(col_rr_1_0xe0ac5b0),
SET_BACKGROUND_MUSIC(0, 53),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_rr_1_),
JUMP_LINK(local_warps_rr_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_rr_1_[] = {
OBJECT_WITH_ACTS(0, 2371, 561, 3629, 0, 180, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, -3746, 1150, 3744, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 6693, 2400, 918, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -1767, 1650, -3974, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -6424, -2700, -7170, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -3791, 2700, 3753, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 5635, 1350, 5636, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(137, -1463, -165, -2279, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(215, 5547, -1024, -5562, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4603, -2878, -4230, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1701, 464, -3567, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -5187, 2200, 1099, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1132, -896, 5742, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6265, -250, 3366, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 854, -1490, -6330, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2859, -2412, -6554, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(84, 3743, -500, -3194, 0, 0, 0, 0x0,  bhvEnemyLakitu, 31),
OBJECT_WITH_ACTS(84, -1354, 1500, -2303, 0, 0, 0, 0x0,  bhvEnemyLakitu, 31),
OBJECT_WITH_ACTS(220, 6099, 1500, -753, 0, 0, 0, 0x10000,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, -3878, -1700, -5177, 0, 0, 0, 0x10000,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(100, -2811, 1849, 2784, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -2811, 1849, 4744, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -4779, 1849, 4744, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(100, -4779, 1849, 2784, 0, 0, 0, 0x0,  bhvPiranhaPlant, 31),
OBJECT_WITH_ACTS(192, -3272, -87, 1494, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -5833, -180, 3488, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(192, -3808, -121, 5950, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(140, 5894, -332, 1027, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 5982, -454, 1352, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 6850, -862, 1175, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5020, -862, 1175, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5950, -862, 2090, 0, 90, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5950, -862, 250, 0, 90, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(220, 5944, 1600, 5013, 0, 0, 0, 0x10000,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(220, 5342, 1600, 6407, 0, 0, 0, 0x10000,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(0, 358, -449, -1018, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 6184, -449, -2612, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, 6654, 150, 6066, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, -4409, -883, -2515, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(192, 5554, -1104, -4752, 0, 0, 0, 0x10000,  bhvGoomba, 31),
OBJECT_WITH_ACTS(137, -5588, 0, 3746, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 6558, 1064, -3229, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(212, 1739, 2500, 6415, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, -5857, 300, 145, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, -2947, 771, -6607, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, -2663, -1318, -7146, 0, 297, 0, 0x130000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -4610, -2878, -2523, 0, 79, 0, 0x130000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 6409, -2194, 3776, 0, 135, 0, 0x130000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(124, -2058, -250, 4047, 0, 112, 0, 0x9e0000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, 10, 5, 300, 0, 0, 20, 9,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_rr_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 3, 45, 0),
WARP_NODE(241, 6, 3, 55, 0),
RETURN()
};
